/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.event.vanilla.BlockStateChangedEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.event.HearthDebugRenderer;
import com.momosoftworks.coldsweat.common.block.HearthBottomBlock;
import com.momosoftworks.coldsweat.common.block.SmokestackBlock;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.container.HearthContainer;
import com.momosoftworks.coldsweat.common.event.HearthSaveDataHandler;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.PredicateItem;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.HearthResetMessage;
import com.momosoftworks.coldsweat.data.tag.ModFluidTags;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.world.SpreadPath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class HearthBlockEntity
extends RandomizableContainerBlockEntity {
    List<SpreadPath> paths = new ArrayList<SpreadPath>(this.getMaxPaths());
    Set<BlockPos> pathLookup = new HashSet<BlockPos>(this.getMaxPaths());
    Map<Pair<Integer, Integer>, Pair<Integer, Boolean>> seeSkyMap = new FastMap<Pair<Integer, Integer>, Pair<Integer, Boolean>>(this.getMaxPaths());
    List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    FluidStack coldFuel = new FluidStack((Fluid)Fluids.f_76193_, 0);
    FluidStack hotFuel = new FluidStack((Fluid)Fluids.f_76195_, 0);
    FluidHandler bottomFuelHandler = new BottomFluidHandler();
    final LazyOptional<IFluidHandler> bottomFuelHolder = LazyOptional.of(() -> this.bottomFuelHandler);
    FluidHandler sidesFuelHandler = new SidesFluidHandler();
    final LazyOptional<IFluidHandler> sidesFuelHolder = LazyOptional.of(() -> this.sidesFuelHandler);
    NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    Pair<BlockPos, ResourceLocation> levelPos = Pair.of(null, null);
    int x = 0;
    int y = 0;
    int z = 0;
    int lastHotFuel = 0;
    int lastColdFuel = 0;
    boolean isSidePowered = false;
    boolean isBackPowered = false;
    boolean shouldUseHotFuel = false;
    boolean shouldUseColdFuel = false;
    boolean hasHotFuel = false;
    boolean hasColdFuel = false;
    int insulationLevel = 0;
    boolean isPlayerNearby = false;
    List<Player> players = new ArrayList<Player>();
    int rebuildCooldown = 0;
    boolean forceRebuild = false;
    List<BlockPos> queuedUpdates = new ArrayList<BlockPos>();
    public int ticksExisted = 0;
    boolean registeredLocation = false;
    boolean showParticles = true;
    int frozenPaths = 0;
    boolean spreading = true;
    boolean hasSmokestack = false;
    int smokestackHeight = 2;
    static final Direction[] DIRECTIONS = Direction.values();
    static Method TICK_DOWN_EFFECT;
    ChunkAccess workingChunk = null;

    public HearthBlockEntity(BlockEntityType type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public HearthBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityInit.HEARTH_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    @SubscribeEvent
    public void onBlockUpdate(BlockStateChangedEvent event) {
        BlockPos pos = event.getPosition();
        Level level = event.getLevel();
        if (level == this.f_58857_ && this.pathLookup.contains(pos) && !event.getOldState().m_60812_((BlockGetter)level, pos).equals(event.getNewState().m_60812_((BlockGetter)level, pos))) {
            this.sendBlockUpdate(pos);
        }
    }

    public int getSpreadRange() {
        return 20;
    }

    public int getMaxRange() {
        return 96;
    }

    public int getMaxPaths() {
        return 12000;
    }

    public int getMaxFuel() {
        return 1000;
    }

    public int getInsulationTime() {
        return 1200;
    }

    public int getInsulationLevel() {
        return this.insulationLevel;
    }

    public int getMaxInsulationLevel() {
        return 10;
    }

    public boolean hasSmokeStack() {
        return true;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.cold_sweat.hearth");
    }

    public Component m_5446_() {
        return this.m_7770_() != null ? this.m_7770_() : this.m_6820_();
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public static <T extends BlockEntity> void tickSelf(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof HearthBlockEntity) {
            HearthBlockEntity hearth = (HearthBlockEntity)te;
            hearth.tick(level, pos);
        }
    }

    public void tick(Level level, BlockPos pos) {
        if (this.ticksExisted == 0) {
            this.init();
        }
        boolean isClient = level.f_46443_;
        ++this.ticksExisted;
        if (this.rebuildCooldown > 0) {
            --this.rebuildCooldown;
        }
        if (this.f_58857_ != null && this.ticksExisted % 20 == 0) {
            this.isPlayerNearby = false;
            this.players.clear();
            for (Player player : this.f_58857_.m_6907_()) {
                if (!player.m_20183_().m_123314_((Vec3i)pos, (double)this.getMaxRange())) continue;
                this.players.add(player);
                this.isPlayerNearby = true;
            }
        }
        this.tickPotionEffects();
        boolean wasUsingColdFuel = this.shouldUseColdFuel;
        boolean wasUsingHotFuel = this.shouldUseHotFuel;
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue()) {
            this.shouldUseColdFuel = this.isSidePowered && this.getColdFuel() > 0;
            boolean bl = this.shouldUseHotFuel = this.isBackPowered && this.getHotFuel() > 0;
        }
        if (!(this.shouldUseColdFuel || this.shouldUseHotFuel || this.paths.isEmpty())) {
            this.forceUpdate();
            this.resetPaths();
        }
        if (this.ticksExisted % 6000 == 0) {
            this.replacePaths(new ArrayList<SpreadPath>(Collections.singletonList(new SpreadPath(pos).setOrigin(pos))));
        }
        if (this.forceRebuild || this.rebuildCooldown <= 0 && !this.queuedUpdates.isEmpty()) {
            this.resetPaths();
        }
        if (this.getColdFuel() > 0 || this.getHotFuel() > 0) {
            if (this.insulationLevel < this.getInsulationTime()) {
                ++this.insulationLevel;
            }
            if (this.shouldUseColdFuel || this.shouldUseHotFuel || ConfigSettings.SMART_HEARTH.get().booleanValue() && this.isPlayerNearby) {
                if (this.ticksExisted % 20 == 0) {
                    boolean bl = this.showParticles = isClient && Minecraft.m_91087_().f_91066_.m_231929_().m_231551_() == ParticleStatus.ALL && !HearthSaveDataHandler.DISABLED_HEARTHS.contains(this.levelPos);
                }
                if (this.paths.isEmpty()) {
                    this.addPath(new SpreadPath(pos.m_6630_(2)).setOrigin(pos.m_6630_(2)));
                    this.pathLookup.add(pos.m_6630_(2));
                }
                this.spreading = this.frozenPaths < this.paths.size();
                int pathCount = this.paths.size();
                int partSize = this.spreading ? CSMath.clamp(pathCount / 3, 100, 4000) : CSMath.clamp(pathCount / 20, 10, 100);
                int partCount = (int)Math.ceil((float)pathCount / (float)partSize);
                int lastIndex = partSize * (this.ticksExisted % partCount + 1);
                int firstIndex = Math.max(0, lastIndex - partSize);
                if (this.paths.size() > 1 || this.ticksExisted % 20 == 0) {
                    this.tickPaths(firstIndex, lastIndex);
                }
                if (isClient && this.spreading && this.paths.size() != pathCount) {
                    HearthDebugRenderer.updatePaths(this);
                }
                if (!isClient && this.ticksExisted % 20 == 0) {
                    if (ConfigSettings.SMART_HEARTH.get().booleanValue()) {
                        this.resetFuelStatus();
                    }
                    for (int i = 0; i < this.players.size(); ++i) {
                        Player player = this.players.get(i);
                        if (player == null || !WorldHelper.allAdjacentBlocksMatch(new BlockPos(player.m_146892_()), bpos -> this.pathLookup.contains(bpos))) continue;
                        this.insulatePlayer(player);
                    }
                    this.players.clear();
                }
                this.tickDrainFuel();
            }
        }
        if (this.ticksExisted % 20 == 0) {
            this.checkForFuel();
        }
        if (!this.f_58857_.f_46443_ && this.isFuelChanged() || wasUsingColdFuel != this.shouldUseColdFuel || wasUsingHotFuel != this.shouldUseHotFuel) {
            this.updateFuelState();
        }
        if (isClient) {
            this.tickParticles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tickPaths(int firstIndex, int lastIndex) {
        int pathCount = this.paths.size();
        for (int i = firstIndex; i < Math.min(this.paths.size(), lastIndex); ++i) {
            SpreadPath spreadPath = this.paths.get(i);
            BlockPos pathPos = spreadPath.pos;
            if (spreadPath.origin == null) {
                spreadPath.setOrigin(this.m_58899_());
            }
            int spX = spreadPath.x;
            int spY = spreadPath.y;
            int spZ = spreadPath.z;
            try {
                if (spreadPath.frozen) {
                    if (this.spreading || Math.abs(spY % 2) == 0 != (Math.abs(spX % 2) == Math.abs(spZ % 2))) continue;
                    this.paths.remove(i);
                    --i;
                    continue;
                }
                if (pathCount < this.getMaxPaths() && spreadPath.withinDistance((Vec3i)spreadPath.origin, this.getSpreadRange()) && CSMath.withinCubeDistance(spreadPath.origin, this.m_58899_(), this.getMaxRange())) {
                    boolean canSeeSky;
                    if (this.workingChunk == null || !this.workingChunk.m_7697_().equals((Object)new ChunkPos(pathPos))) {
                        this.workingChunk = WorldHelper.getChunk((LevelAccessor)this.f_58857_, pathPos);
                    }
                    BlockState state = this.workingChunk != null ? this.workingChunk.m_8055_(pathPos) : this.f_58857_.m_8055_(pathPos);
                    Pair flatPos = Pair.of((Object)spX, (Object)spZ);
                    Pair<Integer, Boolean> seeSkyState = this.seeSkyMap.get(flatPos);
                    if (seeSkyState == null || (Integer)seeSkyState.getFirst() < spY != (Boolean)seeSkyState.getSecond()) {
                        canSeeSky = WorldHelper.canSeeSky((LevelAccessor)this.f_58857_, pathPos.m_7494_(), 64);
                        this.seeSkyMap.put((Pair<Integer, Integer>)flatPos, (Pair<Integer, Boolean>)Pair.of((Object)spY, (Object)canSeeSky));
                    } else {
                        canSeeSky = (Boolean)seeSkyState.getSecond();
                    }
                    if (!canSeeSky || this.isPipe(state)) {
                        for (int d = 0; d < DIRECTIONS.length; ++d) {
                            BlockPos tryPos;
                            Direction direction = DIRECTIONS[d];
                            Direction pathDir = spreadPath.direction;
                            if (direction.m_122434_() == pathDir.m_122434_() && direction != pathDir || this.pathLookup.contains(tryPos = pathPos.m_121945_(direction))) continue;
                            SpreadPath newPath = new SpreadPath(tryPos, direction).setOrigin(spreadPath.origin);
                            if (WorldHelper.isSpreadBlocked((LevelAccessor)this.f_58857_, state, pathPos, direction, spreadPath.direction) || !this.isValidPipeAt(tryPos, state, newPath, direction) || !this.pathLookup.add(tryPos)) continue;
                            this.paths.add(newPath);
                        }
                    } else {
                        this.pathLookup.remove(pathPos);
                        this.paths.remove(i);
                        --i;
                        continue;
                    }
                }
                spreadPath.frozen = true;
                ++this.frozenPaths;
                continue;
            }
            finally {
                if (this.m_58904_().f_46443_ && this.showParticles) {
                    Random rand = new Random();
                    if (!Minecraft.m_91087_().f_91066_.f_92063_ || !ConfigSettings.HEARTH_DEBUG.get().booleanValue()) {
                        this.spawnAirParticle(spX, spY, spZ, rand);
                    }
                }
            }
        }
    }

    public void checkInputSignal() {
        boolean wasBackPowered = this.isBackPowered;
        boolean wasSidePowered = this.isSidePowered;
        if (!this.f_58857_.m_5776_()) {
            this.isBackPowered = this.hasSignalFromBack();
            this.isSidePowered = this.hasSignalFromSides();
            if (this.m_58900_().m_60713_(ModBlocks.HEARTH_BOTTOM)) {
                if (wasBackPowered != this.isBackPowered) {
                    this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)HearthBottomBlock.BACK_POWERED, (Comparable)Boolean.valueOf(this.isBackPowered)), 3);
                }
                if (wasSidePowered != this.isSidePowered) {
                    this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)HearthBottomBlock.SIDE_POWERED, (Comparable)Boolean.valueOf(this.isSidePowered)), 3);
                }
            }
            this.syncInputSignal(wasBackPowered, wasSidePowered);
        }
    }

    protected boolean hasSignalFromSides() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HearthBottomBlock.FACING);
        return this.f_58857_.m_46616_(this.m_58899_().m_121945_(facing.m_122427_()), facing.m_122427_()) || this.f_58857_.m_46616_(this.m_58899_().m_121945_(facing.m_122428_()), facing.m_122428_());
    }

    protected boolean hasSignalFromBack() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HearthBottomBlock.FACING);
        return this.f_58857_.m_46616_(this.m_58899_().m_121945_(facing.m_122424_()), facing.m_122424_()) || this.f_58857_.m_46616_(this.m_58899_().m_121945_(Direction.DOWN), Direction.DOWN);
    }

    protected void syncInputSignal(boolean wasBackPowered, boolean wasSidePowered) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (wasBackPowered != this.isBackPowered || wasSidePowered != this.isSidePowered) {
                serverLevel.m_7726_().m_8450_(this.m_58899_());
            }
        }
    }

    public void checkForFuel() {
        BlockPos pos = this.m_58899_();
        ItemStack fuelStack = (ItemStack)this.m_7086_().get(0);
        if (!fuelStack.m_41619_()) {
            List itemEffects = PotionUtils.m_43547_((ItemStack)fuelStack);
            if (ConfigSettings.HEARTH_POTIONS_ENABLED.get().booleanValue() && !itemEffects.isEmpty() && !itemEffects.equals(this.effects) && itemEffects.stream().noneMatch(eff -> ConfigSettings.HEARTH_POTION_BLACKLIST.get().contains(eff.m_19544_()))) {
                if (fuelStack.m_41720_() instanceof PotionItem) {
                    this.m_7086_().set(0, (Object)Items.f_42590_.m_7968_());
                } else if (!fuelStack.hasCraftingRemainingItem() || fuelStack.m_41613_() > 1) {
                    fuelStack.m_41774_(1);
                } else {
                    this.m_7086_().set(0, (Object)fuelStack.getCraftingRemainingItem());
                }
                this.f_58857_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.effects.clear();
                this.effects.addAll(itemEffects.stream().map(eff -> eff.m_19555_(new CompoundTag())).map(MobEffectInstance::m_19560_).toList());
                WorldHelper.syncBlockEntityData((BlockEntity)this);
            } else if (fuelStack.m_150930_(Items.f_42455_) && !this.effects.isEmpty()) {
                this.m_7086_().set(0, (Object)fuelStack.getCraftingRemainingItem());
                this.f_58857_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.effects.clear();
                WorldHelper.syncBlockEntityData((BlockEntity)this);
            } else {
                int itemFuel = this.getItemFuel(fuelStack);
                if (itemFuel != 0) {
                    this.storeFuel(fuelStack, itemFuel);
                }
            }
        }
    }

    protected boolean isFuelChanged() {
        return Math.abs(this.getColdFuel() - this.lastColdFuel) >= this.getMaxFuel() / 36 || Math.abs(this.getHotFuel() - this.lastHotFuel) >= this.getMaxFuel() / 36;
    }

    protected void storeFuel(ItemStack stack, int amount) {
        int fuel;
        int n = fuel = amount > 0 ? this.getHotFuel() : this.getColdFuel();
        if ((double)fuel < (double)this.getMaxFuel() - (double)Math.abs(amount) * 0.75) {
            if (!stack.hasCraftingRemainingItem() || stack.m_41613_() > 1) {
                int consumeCount = Math.min((int)Math.floor((double)(this.getMaxFuel() - fuel) / (double)Math.abs(amount)), stack.m_41613_());
                stack.m_41774_(consumeCount);
                this.addFuel(amount * consumeCount);
            } else {
                this.m_6836_(0, stack.getCraftingRemainingItem());
                this.addFuel(amount);
            }
        }
    }

    protected void drainFuel() {
        if (this.shouldUseColdFuel) {
            this.setColdFuel(this.getColdFuel() - 1, true);
        }
        if (this.shouldUseHotFuel) {
            this.setHotFuel(this.getHotFuel() - 1, true);
        }
    }

    protected void tickDrainFuel() {
        if (this.ticksExisted % 40 == 0) {
            this.drainFuel();
        }
    }

    protected void resetFuelStatus() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.shouldUseColdFuel = false;
            this.shouldUseHotFuel = false;
        }
    }

    void insulatePlayer(Player player) {
        for (int i = 0; i < this.effects.size(); ++i) {
            MobEffectInstance effect = this.effects.get(i);
            player.m_7292_(new MobEffectInstance(effect.m_19544_(), effect.m_19544_() == MobEffects.f_19611_ ? 399 : 119, effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
        }
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue() || this.shouldInsulatePlayer(player)) {
            int maxEffect = this.getMaxInsulationLevel() - 1;
            int effectLevel = (int)Math.min((double)maxEffect, (double)this.insulationLevel / (double)this.getInsulationTime() * (double)maxEffect);
            if (this.shouldUseColdFuel) {
                player.m_7292_(new MobEffectInstance(ModEffects.CHILL, 120, effectLevel, false, false, true));
            }
            if (this.shouldUseHotFuel) {
                player.m_7292_(new MobEffectInstance(ModEffects.WARMTH, 120, effectLevel, false, false, true));
            }
        }
    }

    protected boolean shouldInsulatePlayer(Player player) {
        AtomicBoolean shouldInsulate = new AtomicBoolean(false);
        if (!this.shouldUseColdFuel || !this.shouldUseHotFuel) {
            EntityTempManager.getTemperatureCap((Entity)player).ifPresent(cap -> {
                double temp = CSMath.getIfNotNull(Temperature.getModifier(cap, Temperature.Trait.WORLD, BlockInsulationTempModifier.class).orElse(null), TempModifier::getLastInput, cap.getTrait(Temperature.Trait.WORLD));
                double min = cap.getTrait(Temperature.Trait.FREEZING_POINT);
                double max = cap.getTrait(Temperature.Trait.BURNING_POINT);
                this.shouldUseHotFuel |= this.getHotFuel() > 0 && temp < min;
                this.shouldUseColdFuel |= this.getColdFuel() > 0 && temp > max;
                shouldInsulate.set(!CSMath.betweenInclusive(temp, min, max));
            });
        }
        return shouldInsulate.get();
    }

    protected boolean isValidPipeAt(BlockPos newPos, BlockState fromState, SpreadPath newPath, Direction direction) {
        if (!this.isPipe(fromState)) {
            return true;
        }
        if (CompatManager.isCreateLoaded()) {
            Block block = fromState.m_60734_();
            if (block instanceof FluidPipeBlock && (Boolean)fromState.m_61143_((Property)PipeBlock.f_55154_.get(direction)) != false || block instanceof GlassFluidPipeBlock && fromState.m_61143_((Property)RotatedPillarBlock.f_55923_) == direction.m_122434_() || block instanceof EncasedPipeBlock && ((Boolean)fromState.m_61143_((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(direction))).booleanValue()) {
                newPath.setOrigin(newPos);
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isPipe(BlockState state) {
        return CompatManager.isCreateLoaded() && (state.m_60734_() instanceof FluidPipeBlock || state.m_60734_() instanceof GlassFluidPipeBlock || state.m_60734_() instanceof EncasedPipeBlock);
    }

    protected void init() {
        this.registerLocation();
        this.checkForSmokestack();
        this.checkInputSignal();
    }

    private void registerLocation() {
        if (!this.registeredLocation) {
            this.levelPos = Pair.of((Object)this.m_58899_(), (Object)this.f_58857_.m_46472_().m_135782_());
            HearthSaveDataHandler.HEARTH_POSITIONS.add(this.levelPos);
            this.x = this.m_58899_().m_123341_();
            this.y = this.m_58899_().m_123342_();
            this.z = this.m_58899_().m_123343_();
            this.registeredLocation = true;
        }
    }

    private void unregisterLocation() {
        if (this.registeredLocation) {
            HearthSaveDataHandler.HEARTH_POSITIONS.remove(this.levelPos);
            this.registeredLocation = false;
        }
    }

    protected void tickPotionEffects() {
        if (!this.effects.isEmpty()) {
            this.effects.removeIf(effect -> {
                try {
                    TICK_DOWN_EFFECT.invoke(effect, new Object[0]);
                    if (effect.m_19557_() <= 0) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            });
        }
    }

    void resetPaths() {
        this.rebuildCooldown = 100;
        this.paths.clear();
        this.pathLookup.clear();
        if (this.forceRebuild) {
            this.seeSkyMap.clear();
        } else {
            for (int i = 0; i < this.queuedUpdates.size(); ++i) {
                BlockPos pos = this.queuedUpdates.get(i);
                this.seeSkyMap.remove(Pair.of((Object)pos.m_123341_(), (Object)pos.m_123343_()));
            }
        }
        this.frozenPaths = 0;
        this.spreading = true;
        this.sendResetPacket();
        if (this.f_58857_.f_46443_) {
            HearthDebugRenderer.updatePaths(this);
        }
        this.forceRebuild = false;
        this.queuedUpdates.clear();
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public int getItemFuel(ItemStack item) {
        return ConfigHelper.findFirstItemMatching(ConfigSettings.HEARTH_FUEL, item).map(PredicateItem::value).orElse(0.0).intValue();
    }

    public int getHotFuel() {
        return this.hotFuel.getAmount();
    }

    public int getColdFuel() {
        return this.coldFuel.getAmount();
    }

    public void setHotFuel(int amount, boolean update) {
        if (this.hotFuel.isEmpty()) {
            this.hotFuel = new FluidStack((Fluid)Fluids.f_76195_, amount);
        } else {
            this.hotFuel.setAmount(amount);
        }
        if (amount == 0) {
            if (this.hasHotFuel) {
                this.hasHotFuel = false;
                if (this.f_58857_ != null) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), this.getFuelDepleteSound(), SoundSource.BLOCKS, 1.0f, (float)Math.random() * 0.2f + 0.9f);
                }
            }
        } else {
            this.hasHotFuel = true;
        }
        if (update) {
            this.updateFuelState();
        }
    }

    public void setHotFuelAndUpdate(int amount) {
        this.setHotFuel(amount, true);
    }

    public void setColdFuel(int amount, boolean update) {
        if (this.coldFuel.isEmpty()) {
            this.coldFuel = new FluidStack((Fluid)Fluids.f_76193_, amount);
        } else {
            this.coldFuel.setAmount(amount);
        }
        if (amount <= 0) {
            if (this.hasColdFuel) {
                this.hasColdFuel = false;
                if (this.f_58857_ != null) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), this.getFuelDepleteSound(), SoundSource.BLOCKS, 1.0f, (float)Math.random() * 0.2f + 0.9f);
                }
            }
        } else {
            this.hasColdFuel = true;
        }
        if (update) {
            this.updateFuelState();
        }
    }

    public void setColdFuelAndUpdate(int amount) {
        this.setColdFuel(amount, true);
    }

    public void addFuel(int amount) {
        if (amount > 0) {
            this.setHotFuelAndUpdate(this.getHotFuel() + amount);
        } else if (amount < 0) {
            this.setColdFuelAndUpdate(this.getColdFuel() + Math.abs(amount));
        }
    }

    public void updateFuelState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            WorldHelper.syncBlockEntityData((BlockEntity)this);
            this.lastColdFuel = this.getColdFuel();
            this.lastHotFuel = this.getHotFuel();
        }
    }

    protected SoundEvent getFuelDepleteSound() {
        return ModSounds.HEARTH_DEPLETE;
    }

    public boolean checkForSmokestack() {
        if (this.f_58857_ == null) {
            return false;
        }
        boolean hadSmokestack = this.hasSmokestack;
        boolean bl = this.hasSmokestack = this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60734_() == ModBlocks.SMOKESTACK;
        if (this.hasSmokestack && !hadSmokestack) {
            this.registerLocation();
            if (this.f_58857_.f_46443_) {
                ClientOnlyHelper.addHearthPosition(this.m_58899_());
            }
        } else if (!this.hasSmokestack && hadSmokestack) {
            this.forceUpdate();
            this.resetPaths();
            this.unregisterLocation();
            if (this.f_58857_.f_46443_) {
                ClientOnlyHelper.removeHearthPosition(this.m_58899_());
            }
        }
        return this.hasSmokestack;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickParticles() {
        double d5;
        double d4;
        double d3;
        double d2;
        double d1;
        double d0;
        ParticleStatus status = (ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_();
        if (status == ParticleStatus.MINIMAL) {
            return;
        }
        if (this.ticksExisted % 20 == 0) {
            this.smokestackHeight = 2;
            BlockState state = this.f_58857_.m_8055_(this.m_58899_().m_6630_(this.smokestackHeight));
            while (state.m_60734_() instanceof WallBlock || state.m_60734_() instanceof SmokestackBlock) {
                ++this.smokestackHeight;
                state = this.f_58857_.m_8055_(this.m_58899_().m_6630_(this.smokestackHeight));
            }
        }
        RandomSource rand = this.f_58857_.f_46441_;
        if (this.shouldUseColdFuel && rand.m_188500_() < (double)this.getColdFuel() / 3000.0) {
            d0 = (double)this.x + 0.5;
            d1 = this.y + this.smokestackHeight;
            d2 = (double)this.z + 0.5;
            d3 = (rand.m_188500_() - 0.5) / 4.0;
            d4 = (rand.m_188500_() - 0.5) / 4.0;
            d5 = (rand.m_188500_() - 0.5) / 4.0;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypesInit.STEAM.get(), d0 + d3, d1 + d4, d2 + d5, 0.0, 0.04, 0.0);
        }
        if (this.shouldUseHotFuel && rand.m_188500_() < (double)this.getHotFuel() / 3000.0) {
            d0 = (double)this.x + 0.5;
            d1 = this.y + this.smokestackHeight;
            d2 = (double)this.z + 0.5;
            d3 = (rand.m_188500_() - 0.5) / 2.0;
            d4 = (rand.m_188500_() - 0.5) / 2.0;
            d5 = (rand.m_188500_() - 0.5) / 2.0;
            SimpleParticleType particle = rand.m_188500_() < 0.5 ? ParticleTypes.f_123755_ : ParticleTypes.f_123762_;
            this.f_58857_.m_7106_((ParticleOptions)particle, d0 + d3, d1 + d4, d2 + d5, 0.0, 0.0, 0.0);
        }
    }

    public ParticleOptions getAirParticle() {
        return (ParticleOptions)ParticleTypesInit.HEARTH_AIR.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnAirParticle(int x, int y, int z, Random rand) {
        float f = rand.nextFloat();
        float f2 = this.spreading ? 0.016f : 0.032f;
        if (f > f2) {
            return;
        }
        float xr = rand.nextFloat();
        float yr = rand.nextFloat();
        float zr = rand.nextFloat();
        float xm = rand.nextFloat() / 20.0f - 0.025f;
        float zm = rand.nextFloat() / 20.0f - 0.025f;
        this.f_58857_.m_6493_(this.getAirParticle(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
    }

    public int m_6643_() {
        return 1;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInv) {
        return new HearthContainer(id, playerInv, this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.loadEffects(tag);
        this.coldFuel = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("ColdFuel"));
        this.hotFuel = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("HotFuel"));
        this.insulationLevel = tag.m_128451_("InsulationLevel");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        this.saveEffects(tag);
        tag.m_128365_("ColdFuel", (Tag)this.coldFuel.writeToNBT(new CompoundTag()));
        tag.m_128365_("HotFuel", (Tag)this.hotFuel.writeToNBT(new CompoundTag()));
        tag.m_128405_("InsulationLevel", this.insulationLevel);
    }

    void saveEffects(CompoundTag tag) {
        if (!this.effects.isEmpty()) {
            ListTag list = new ListTag();
            for (MobEffectInstance effect : this.effects) {
                list.add((Object)effect.m_19555_(new CompoundTag()));
            }
            tag.m_128365_("Effects", (Tag)list);
        }
    }

    void loadEffects(CompoundTag tag) {
        this.effects.clear();
        if (tag.m_128441_("Effects")) {
            ListTag list = tag.m_128437_("Effects", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.effects.add(MobEffectInstance.m_19560_((CompoundTag)list.m_128728_(i)));
            }
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("HotFuel", this.getHotFuel());
        tag.m_128405_("ColdFuel", this.getColdFuel());
        tag.m_128379_("ShouldUseColdFuel", this.shouldUseColdFuel);
        tag.m_128379_("ShouldUseHotFuel", this.shouldUseHotFuel);
        tag.m_128405_("InsulationLevel", this.insulationLevel);
        tag.m_128379_("IsSidePowered", this.isSidePowered);
        tag.m_128379_("IsBackPowered", this.isBackPowered);
        tag.m_128379_("HasSmokestack", this.hasSmokestack);
        this.saveEffects(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setHotFuel(tag.m_128451_("HotFuel"), false);
        this.setColdFuel(tag.m_128451_("ColdFuel"), false);
        this.shouldUseColdFuel = tag.m_128471_("ShouldUseColdFuel");
        this.shouldUseHotFuel = tag.m_128471_("ShouldUseHotFuel");
        this.insulationLevel = tag.m_128451_("InsulationLevel");
        this.isSidePowered = tag.m_128471_("IsSidePowered");
        this.isBackPowered = tag.m_128471_("IsBackPowered");
        this.hasSmokestack = tag.m_128471_("HasSmokestack");
        this.loadEffects(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.FLUID_HANDLER && facing != null ? (facing == Direction.DOWN ? this.bottomFuelHolder.cast() : (facing != Direction.UP && facing != this.m_58900_().m_61143_((Property)HearthBottomBlock.FACING) ? this.sidesFuelHolder.cast() : super.getCapability(capability, facing))) : super.getCapability(capability, facing);
    }

    public void replacePaths(ArrayList<SpreadPath> newPaths) {
        this.frozenPaths = 0;
        this.paths = newPaths;
        this.pathLookup = newPaths.stream().map(path -> path.pos).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        this.spreading = true;
        if (this.f_58857_.f_46443_) {
            ClientOnlyHelper.addHearthPosition(this.m_58899_());
        }
        this.sendResetPacket();
    }

    public void addPath(SpreadPath path) {
        this.paths.add(path);
    }

    public void addPaths(Collection<SpreadPath> newPaths) {
        this.paths.addAll(newPaths);
    }

    public void sendResetPacket() {
        if (this.f_58857_ instanceof ServerLevel) {
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> (LevelChunk)WorldHelper.getChunk((LevelAccessor)this.f_58857_, this.m_58899_())), (Object)new HearthResetMessage(this.m_58899_()));
        }
    }

    public void sendBlockUpdate(BlockPos pos) {
        this.queuedUpdates.add(pos);
    }

    public void forceUpdate() {
        this.forceRebuild = true;
        this.sendBlockUpdate(this.m_58899_());
    }

    public void m_7651_() {
        super.m_7651_();
        HearthSaveDataHandler.HEARTH_POSITIONS.remove(Pair.of((Object)this.m_58899_(), (Object)this.m_58904_().m_46472_().m_135782_()));
        if (this.f_58857_.f_46443_) {
            ClientOnlyHelper.removeHearthPosition(this.m_58899_());
        }
    }

    public Set<BlockPos> getPathLookup() {
        return this.pathLookup;
    }

    public List<SpreadPath> getPaths() {
        return this.paths;
    }

    public boolean isSpreading() {
        return this.spreading;
    }

    public boolean isSidePowered() {
        return this.isSidePowered;
    }

    public boolean isBackPowered() {
        return this.isBackPowered;
    }

    public void setSidePowered(boolean isPowered) {
        this.isSidePowered = isPowered;
    }

    public void setBackPowered(boolean isPowered) {
        this.isBackPowered = isPowered;
    }

    static {
        try {
            TICK_DOWN_EFFECT = ObfuscationReflectionHelper.findMethod(MobEffectInstance.class, (String)"m_19579_", (Class[])new Class[0]);
            TICK_DOWN_EFFECT.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class BottomFluidHandler
    extends FluidHandler {
        private BottomFluidHandler() {
        }

        @Override
        public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
            int drained = Math.min(HearthBlockEntity.this.hotFuel.getAmount(), amount);
            FluidStack stack = new FluidStack(HearthBlockEntity.this.hotFuel, drained);
            if (fluidAction.execute() && drained > 0) {
                HearthBlockEntity.this.hotFuel.shrink(drained);
            }
            HearthBlockEntity.this.m_6596_();
            return stack;
        }
    }

    public abstract class FluidHandler
    implements IFluidHandler {
        public int getTanks() {
            return 2;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? HearthBlockEntity.this.coldFuel : HearthBlockEntity.this.hotFuel;
        }

        public int getTankCapacity(int tank) {
            return HearthBlockEntity.this.getMaxFuel();
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
            return tank == 0 ? fluidStack.getFluid() == Fluids.f_76193_ : fluidStack.getFluid() == Fluids.f_76195_;
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            if (fluidStack.getFluid().m_205067_(ModFluidTags.COLD)) {
                int amount = Math.min(fluidStack.getAmount(), this.getTankCapacity(0) - HearthBlockEntity.this.coldFuel.getAmount());
                if (fluidAction.execute()) {
                    if (HearthBlockEntity.this.coldFuel.isEmpty()) {
                        HearthBlockEntity.this.coldFuel = fluidStack.copy();
                    } else {
                        HearthBlockEntity.this.coldFuel.grow(amount);
                    }
                }
                return amount;
            }
            if (fluidStack.getFluid().m_205067_(ModFluidTags.HOT)) {
                int amount = Math.min(fluidStack.getAmount(), this.getTankCapacity(1) - HearthBlockEntity.this.hotFuel.getAmount());
                if (fluidAction.execute()) {
                    if (HearthBlockEntity.this.hotFuel.isEmpty()) {
                        HearthBlockEntity.this.hotFuel = fluidStack.copy();
                    } else {
                        HearthBlockEntity.this.hotFuel.grow(amount);
                    }
                }
                return amount;
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return this.isFluidValid(0, fluidStack) || this.isFluidValid(1, fluidStack) ? this.drain(fluidStack.getAmount(), fluidAction) : FluidStack.EMPTY;
        }

        public abstract FluidStack drain(int var1, IFluidHandler.FluidAction var2);
    }

    private class SidesFluidHandler
    extends FluidHandler {
        private SidesFluidHandler() {
        }

        @Override
        public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
            int drained = Math.min(HearthBlockEntity.this.coldFuel.getAmount(), amount);
            FluidStack stack = new FluidStack(HearthBlockEntity.this.coldFuel, drained);
            if (fluidAction.execute() && drained > 0) {
                HearthBlockEntity.this.coldFuel.shrink(drained);
            }
            HearthBlockEntity.this.m_6596_();
            return stack;
        }
    }
}

